import { type ClientSchema, a, defineData } from '@aws-amplify/backend';

const schema = a.schema({
  Docs: a
    .model({
      login:a.string(),
      date: a.string(),
      type: a.string(),
      category:a.string(),
      description: a.string(),
      encrypted: a.string(),
      amount: a.float(),
      image: a.string(),
    })
    .authorization((allow) => [allow.authenticated()]),
});

export type Schema = ClientSchema<typeof schema>;

export const data = defineData({
  schema,
  authorizationModes: {
    defaultAuthorizationMode: 'userPool',
  },
});